#region Includes
using GroundhogLearning.GameKit.Utils;
using UnityEngine;
#endregion

namespace GroundhogLearning.GameKit
{
    [AddComponentMenu(EditorMenuConfig.CATEGORY_TRANSFORMS + "Rotator")]
    public class Rotator : MonoBehaviour
    {
        #region Variables

        [Header("Configuration")]
        [SerializeField, Tooltip("If true, rotation begins automatically when the scene starts.")]
        private bool _autoStart = true;

        [SerializeField, Tooltip("Axis around which the object will rotate (X, Y, Z).")]
        private Vector3 _rotationAxis = Vector3.up;

        [SerializeField, Tooltip("Rotation speed in degrees per second.")]
        private float _rotationSpeed = 90f;

        private bool _isRotating;

        #endregion

        private void Start()
        {
            if (_autoStart)
            {
                _isRotating = true;
            }
        }
        private void Update()
        {
            if (!_isRotating) return;
            Rotate();
        }

        private void Rotate()
        {
            transform.Rotate(_rotationAxis.normalized * _rotationSpeed * Time.deltaTime, Space.Self);
        }

        public void StartRotation() => _isRotating = true;
        public void StopRotation() => _isRotating = false;

#if UNITY_EDITOR
        private void OnDrawGizmosSelected()
        {
            Gizmos.color = Color.green;
            Gizmos.DrawRay(transform.position, _rotationAxis.normalized);
        }
#endif
    }
}
